import os
import argparse

parser = argparse.ArgumentParser()
parser.add_argument("--gpu", required=True, type=int)
args, unparsed = parser.parse_known_args()
assert args.gpu in [0,1,2,3]

os.environ["CUDA_VISIBLE_DEVICES"] = str(args.gpu)


cath_calls = [
    "python3 ./se3cnn/experiments/scripts/cath/cath.py --data-filename ./se3cnn/data/cath_10arch_ca.npz --model ILPOResNet34hardmax --training-epochs 100 --batch-size 4 --batchsize-multiplier 1 --randomize-orientation --kernel-size 3 --initial_lr=0.0005 --lr_decay_start=40 --burnin-epochs 40 --lr_decay_base=.94 --downsample-by-pooling --p-drop-conv 0.01 --report-frequency 1 --lamb_conv_weight_L1 1e-7 --lamb_conv_weight_L2 1e-7 --lamb_bn_weight_L1 1e-7 --lamb_bn_weight_L2 1e-7 --report-on-test-set ",
    "python3 ./se3cnn/experiments/scripts/cath/cath.py --data-filename ./se3cnn/data/cath_10arch_ca.npz --model ILPOResNet34softmax --training-epochs 100 --batch-size 4 --batchsize-multiplier 1 --randomize-orientation --kernel-size 3 --initial_lr=0.0005 --lr_decay_start=40 --burnin-epochs 40 --lr_decay_base=.94 --downsample-by-pooling --p-drop-conv 0.01 --report-frequency 1 --lamb_conv_weight_L1 1e-7 --lamb_conv_weight_L2 1e-7 --lamb_bn_weight_L1 1e-7 --lamb_bn_weight_L2 1e-7 --report-on-test-set  ",
    "python3 ./se3cnn/experiments/scripts/cath/cath.py --data-filename ./se3cnn/data/cath_10arch_ca.npz --model ILPOResNet34Smallhardmax --training-epochs 100 --batch-size 4 --batchsize-multiplier 1 --randomize-orientation --kernel-size 3 --initial_lr=0.0005 --lr_decay_start=40 --burnin-epochs 40 --lr_decay_base=.94 --downsample-by-pooling --p-drop-conv 0.01 --report-frequency 1 --lamb_conv_weight_L1 1e-7 --lamb_conv_weight_L2 1e-7 --lamb_bn_weight_L1 1e-7 --lamb_bn_weight_L2 1e-7 --report-on-test-set ",
    "python3 ./se3cnn/experiments/scripts/cath/cath.py --data-filename ./se3cnn/data/cath_10arch_ca.npz --model ILPOResNet34Smallsoftmax --training-epochs 100 --batch-size 4 --batchsize-multiplier 1 --randomize-orientation --kernel-size 3 --initial_lr=0.0005 --lr_decay_start=40 --burnin-epochs 40 --lr_decay_base=.94 --downsample-by-pooling --p-drop-conv 0.01 --report-frequency 1 --lamb_conv_weight_L1 1e-7 --lamb_conv_weight_L2 1e-7 --lamb_bn_weight_L1 1e-7 --lamb_bn_weight_L2 1e-7 --report-on-test-set ",
    "python3 ./se3cnn/experiments/scripts/cath/cath.py --data-filename ./se3cnn/data/cath_10arch_ca.npz --model ILPOResNet34Tinyhardmax --training-epochs 100 --batch-size 4 --batchsize-multiplier 1 --randomize-orientation --kernel-size 3 --initial_lr=0.0005 --lr_decay_start=40 --burnin-epochs 40 --lr_decay_base=.94 --downsample-by-pooling --p-drop-conv 0.01 --report-frequency 1 --lamb_conv_weight_L1 1e-7 --lamb_conv_weight_L2 1e-7 --lamb_bn_weight_L1 1e-7 --lamb_bn_weight_L2 1e-7 --report-on-test-set ",
    "python3 ./se3cnn/experiments/scripts/cath/cath.py --data-filename ./se3cnn/data/cath_10arch_ca.npz --model ILPOResNet34Tinysoftmax --training-epochs 100 --batch-size 4 --batchsize-multiplier 1 --randomize-orientation --kernel-size 3 --initial_lr=0.0005 --lr_decay_start=40 --burnin-epochs 40 --lr_decay_base=.94 --downsample-by-pooling --p-drop-conv 0.01 --report-frequency 1 --lamb_conv_weight_L1 1e-7 --lamb_conv_weight_L2 1e-7 --lamb_bn_weight_L1 1e-7 --lamb_bn_weight_L2 1e-7 --report-on-test-set  ",
]
         
for cath_call in cath_calls:
    os.system(cath_call)

medmnist_model18_calls = [
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag adrenalmnist3d  --conv Conv3d --model_flag ilporesnet18  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag fracturemnist3d  --conv Conv3d --model_flag ilporesnet18  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag nodulemnist3d  --conv Conv3d --model_flag ilporesnet18  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag organmnist3d  --conv Conv3d --model_flag ilporesnet18  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag synapsemnist3d  --conv Conv3d --model_flag ilporesnet18  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag vesselmnist3d  --conv Conv3d --model_flag ilporesnet18  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                        ]
medmnist_model18small_calls = [
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag adrenalmnist3d  --conv Conv3d --model_flag ilporesnet18small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag fracturemnist3d  --conv Conv3d --model_flag ilporesnet18small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag nodulemnist3d  --conv Conv3d --model_flag ilporesnet18small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag organmnist3d  --conv Conv3d --model_flag ilporesnet18small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag synapsemnist3d  --conv Conv3d --model_flag ilporesnet18small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag vesselmnist3d  --conv Conv3d --model_flag ilporesnet18small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            ]
medmnist_model50_calls = [
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag adrenalmnist3d  --conv Conv3d --model_flag ilporesnet50  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag fracturemnist3d  --conv Conv3d --model_flag ilporesnet50  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag nodulemnist3d  --conv Conv3d --model_flag ilporesnet50  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag organmnist3d  --conv Conv3d --model_flag ilporesnet50  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag synapsemnist3d  --conv Conv3d --model_flag ilporesnet50  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag vesselmnist3d  --conv Conv3d --model_flag ilporesnet50  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                        ]
medmnist_model50small_calls = [
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag adrenalmnist3d  --conv Conv3d --model_flag ilporesnet50small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag fracturemnist3d  --conv Conv3d --model_flag ilporesnet50small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag nodulemnist3d  --conv Conv3d --model_flag ilporesnet50small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag organmnist3d  --conv Conv3d --model_flag ilporesnet50small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag synapsemnist3d  --conv Conv3d --model_flag ilporesnet50small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            "python3 ./MedMNIST/experiments/MedMNIST3D/train_and_eval_pytorch.py --data_flag vesselmnist3d  --conv Conv3d --model_flag ilporesnet50small  --download --output_root ./MedMNIST/experiments/MedMNIST3D/output/ --so3_size 4 --pooling_type hardmax --dropout 0.01 --learning_rate 0.005",
                            ]
medmnist_calls = [
                    medmnist_model18_calls, 
                    medmnist_model18small_calls,
                    medmnist_model50_calls,
                    medmnist_model50small_calls
                ]

for medmnist_model_calls in medmnist_calls:
    for medmnist_call in medmnist_model_calls:
        os.system(medmnist_call)